/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.thema;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.ThesaurusDatabase;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;
import data.structures.thema.ThemaItem;
import data.structures.corpus.CorpusGraph;

import java.util.Set;
import java.util.Vector;


/**
 *
 * @author claitang1
 */
public class ThemaIdentifier {
    //private Set<Graph_item> myThemaItem, myRSSGraphItems;
    private Database myDB;

    public ThemaIdentifier(Database db){
        myDB = db;
        //getThemaGraph();
    }

    /**
     * Crée un tableau avec 40 identifiant de dépêches
     */
    /*public void process(){

        int[] test = {1,2,29,39,68,77,89,104,122,183,226,247,258,277,284,330,
        332,347,388,403,414,427,446,802,850,940,1029,26,2117,396,398,419,518,
        524,2641,2642,2867,2887,2889};
        myRSSGraphItems = getRSSItemsGraph(test);
        analyse(3);
    }*/

    public String[] processCorpus() throws NoBaseException{
        currentState = 0;
        GraphLemmaItem[] corpusGraphItems = new CorpusGraph(myDB).getItems();
        //System.out.println("!!Taille du corpus : "+corpusGraphItems.length);
        String[] thematiques = new String[corpusGraphItems.length];
        for(int i=0; i<corpusGraphItems.length; i++){
            currentState++;
            //System.out.println("!!!"+corpusGraphItems[i].getNodeID()+" - "+corpusGraphItems[i].getNodeName());
            //System.out.println("!!!Nombre de lemmes : "+corpusGraphItems[i].getLemmas().size());
            String[] nouveauxLemmes = addSemanticEnrichment(corpusGraphItems[i], 3);
            //System.out.println("!!!Nombre de concepts trouvés : "+nouveauxLemmes.length);
            //System.out.print("*");
            /*for(int j=0; j<nouveauxLemmes.length; j++){
                System.out.print(nouveauxLemmes[j]+" ; ");
            } System.out.println("");*/
            thematiques[i] = evalueThematique(corpusGraphItems[i], nouveauxLemmes);
        }
        return thematiques;
    }
    private int currentState = 0;
    public int getCurrentState(){
        return currentState;
    }

    private String evalueThematique(GraphLemmaItem g, String[] nouveauxLemmes){
        String[] lemmes = g.getLemmasAsStrings();
        return "";
    }

    public String[] calculDirect() throws NoBaseException {
        currentState = 0;
        String[] resultat = {};
        ThesaurusDatabase base = new ThesaurusDatabase(myDB);
        Set<ThemaItem> thematiques0 = base.getTopClasses();
        ThemaItem[] thematiques = new ThemaItem[thematiques0.size()];
        thematiques0.toArray(thematiques);
        Vector[] lemmesThema0 = new Vector[thematiques.length];
        for(int i=0; i<thematiques.length; i++){
            lemmesThema0[i] = new Vector(base.getLemmas(thematiques[i].getConceptID()));
        }
        GraphLemmaItem[] corpusGraphItems = new CorpusGraph(myDB).getItems();
        resultat = new String[corpusGraphItems.length];
        for(int i=0; i<corpusGraphItems.length; i++){
            currentState++;
            int[] scores = new int[thematiques.length];
            String[] lemmes = corpusGraphItems[i].getLemmasAsStrings();
            for(int j=0; j<scores.length; j++){
                String[] lemmesThema = new String[lemmesThema0[j].size()];
                for(int k=0; k<lemmesThema.length; k++){
                    lemmesThema[k] = ((LemmaItem)(lemmesThema0[j].elementAt(k))).getLemmaName();
                }
                scores[j] = 0;
                for(int a=0; a<lemmes.length; a++){
                    for(int b=0; b<lemmesThema.length; b++){
                        double sim = calculSimilarite(lemmes[a], lemmesThema[b]);
                        scores[j]+=(int)(10000*sim/(lemmesThema.length+10));
                    }
                }
            }
            int scoreMax = 0;
            ThemaItem themaMax = null;
            for(int j=0; j<scores.length; j++){
                if(scores[j]>scoreMax){
                    scoreMax = scores[j];
                    themaMax = thematiques[j];
                }
            }
            if(scoreMax>0){
                resultat[i] = themaMax.getConceptName();
            } else {
                resultat[i] = "";
            }
        }
        return resultat;
    }

    private double calculSimilarite(String a, String b){
        return a.equalsIgnoreCase(b)?1.0:0.0;
    }

    public String[] calculDirect2() throws NoBaseException {
        currentState = 0;
        String[] resultat = {};
        ThesaurusDatabase base = new ThesaurusDatabase(myDB);
        Set<ThemaItem> thematiques0 = base.getTopClasses();
        ThemaItem[] thematiques = new ThemaItem[thematiques0.size()];
        thematiques0.toArray(thematiques);
        Vector[] lemmesThema0 = new Vector[thematiques.length];
        for(int i=0; i<thematiques.length; i++){
            lemmesThema0[i] = new Vector(base.getExtendedLemmas(thematiques[i].getConceptID()));
        }
        GraphLemmaItem[] corpusGraphItems = new CorpusGraph(myDB).getItems();
        resultat = new String[corpusGraphItems.length];
        for(int i=0; i<corpusGraphItems.length; i++){
            currentState++;
            int[] scores = new int[thematiques.length];
            String[] lemmes = corpusGraphItems[i].getLemmasAsStrings();
            for(int j=0; j<scores.length; j++){
                String[] lemmesThema = new String[lemmesThema0[j].size()];
                for(int k=0; k<lemmesThema.length; k++){
                    lemmesThema[k] = ((LemmaItem)(lemmesThema0[j].elementAt(k))).getLemmaName();
                }
                scores[j] = 0;
                for(int a=0; a<lemmes.length; a++){
                    for(int b=0; b<lemmesThema.length; b++){
                        if(lemmes[a].equalsIgnoreCase(lemmesThema[b])){
                            double sim = calculSimilarite(lemmes[a], lemmesThema[b]);
                            scores[j]+=(int)(10000*sim/(lemmesThema.length+10));
                        }
                    }
                }
            }
            int scoreMax = 0;
            ThemaItem themaMax = null;
            for(int j=0; j<scores.length; j++){
                if(scores[j]>scoreMax){
                    scoreMax = scores[j];
                    themaMax = thematiques[j];
                }
            }
            if(scoreMax>0){
                resultat[i] = themaMax.getConceptName();
            } else {
                resultat[i] = "";
            }
        }
        return resultat;
    }

    /**
     * Récupère les dépèches du tableau myItems en paramètre et construit un objet graph
     * @param myItems
     * @return l'objet graph contenant les noeuds représentant les dépêches sans relations entre-elles
     */
    /*private LinkedHashSet<Graph_item> getRSSItemsGraph(int[] myItems){
        LinkedHashSet<Graph_item> rssGraphItems = new LinkedHashSet<Graph_item>();
        for(int i = 0; i<myItems.length; i++){
            RSS_graph myGraph = new RSS_graph(myDB);
            myGraph.setNode(myItems[i]);
            Graph_item node = myGraph.getNode();
            rssGraphItems.add(node);
        }
        return rssGraphItems;
    }*/

    /**
     * creation du graph pour les thématiques
     */
    /*private void getThemaGraph(){
        Thema_graph tg = new Thema_graph(myDB);
        myThemaItem = tg.getNodes();
    }*/

    /*private void analyse(int steps){
        Iterator rss_iter = myRSSGraphItems.iterator();
        // pour chaque depeche dans notre sélection process du rapprochement semantique
        while(rss_iter.hasNext()){
            Graph_item myItem = (Graph_item) rss_iter.next();
            System.out.println("avant"+myItem.getLemmas().size());
            addSemanticEnrichment(myItem, steps);
            System.out.println("apres"+myItem.getLemmas().size());
            getThemaEval(myItem);
        }
    }*/

    private String[] addSemanticEnrichment(GraphLemmaItem myItem, int steps) throws NoBaseException {
        //recupération des lemmes d'origine
        Set<LemmaItem> myLemmas = myItem.getLemmas();
        //recupération des lemmes de données sémantiques
        /*DBPediaDatabase db = new DBPediaDatabase(myDB);
        Set<Ressource_item> myRessources = db.getRelatedItems(myItem.getNodeID());*/
        OntologyLinker ol = new OntologyLinker(myDB);
        Set<String> resultat = ol.getGeneralisation(myLemmas, steps);
        /*Iterator iter = myRessources.iterator();
        while(iter.hasNext()){
            Ressource_item ressource = (Ressource_item) iter.next();
            if(!ressource.getDescLemmas().isEmpty()){
                String[] temp = ressource.getDescLemmas().split(" ");
                for(int i=0; i<temp.length;i++){
                    Lemma_item lemma = new Lemma_item();
                    if((!temp[i].equalsIgnoreCase("null")) && (temp[i].length()>2)){
                        lemma.setLemmaName(temp[i]);
                        lemma.setCountDesc(1);
                        lemma.setCountTitle(0);
                        myLemmas.add(lemma);
                    }
                }
            }
        }*/
        //myItem.setLemmas(myLemmas);
        String[] s = new String[resultat.size()];
        resultat.toArray(s);
        return s;
    }
    //fonction de rapprochement semantique
    /*private void getThemaEval(Graph_item item){
        Set<Graph_item> root = new LinkedHashSet<Graph_item>();
        Iterator thema_iter = myThemaItem.iterator();
        while(thema_iter.hasNext()){
            Graph_item thema_item = (Graph_item) thema_iter.next();
            if(thema_item.getParents().isEmpty()){
                root.add(thema_item);
            }
        }
        Iterator root_iter = root.iterator();
        HashMap results = new HashMap();
        while(root_iter.hasNext()){
            Graph_item thema_item = (Graph_item) root_iter.next();
            results.put(thema_item.getNodeName(), evaluation(thema_item, item));
        }
        displayResults(results);
    }*/

    /*private double evaluation(Graph_item thema_item, Graph_item article){
        double result = 0.0000;
        //récupération des lemmes de l'article
        Set<Lemma_item> article_lemmes = article.getLemmas();
        //evaluation premier niveau
        Set<Lemma_item> thema_lemmas = thema_item.getLemmas();
        result += calcul(thema_lemmas, article_lemmes)/thema_lemmas.size();
        //evaluation de second niveau
        Set<Lemma_item> childs_thema_lemmas = childLemmas(thema_item);
        result += (calcul(childs_thema_lemmas, article_lemmes)/childs_thema_lemmas.size())/2;
        //evaluation de troisieme niveau
        Iterator gc_iter = thema_item.getChilds().iterator();
        //while(gc_iter.hasNext()){
        //    Graph_item gc_item = (Graph_item) gc_iter.next();
        //    result += (calcul(gc_item.getLemmas(), article_lemmes)/gc_item.getLemmas().size())/4;
        //}
        return result;
    }*/

    /**
     * calcul la similarité entre l'enxemble des lemmes d'un thème (thema_lemmas)
     * et l'ensemble des lemmes d'un dépèche (article_lemmas)
     * @param thema_lemmas
     * @param article_lemmas
     * @param niveau
     * @return count_of _identical_lemmas/count_different_lemmas
     */
    //private double calcul(Set<Lemma_item> thema_lemmas, Set<Lemma_item> article_lemmas){
       
/*        Set<Lemma_item> intersection= new HashSet<Lemma_item>();
        Set<Lemma_item> union = new HashSet<Lemma_item>();
        intersection.addAll(article_lemmas);
        intersection.retainAll(thema_lemmas);
        union.addAll(thema_lemmas);
        union.addAll(article_lemmas); //becomes the union of the 2 lemma sets
        System.out.println(intersection.size());
        return (intersection.size()/union.size());// /niveau;
*/
        /*double result = 0.0000;
        Iterator lemmas_iter = thema_lemmas.iterator();
        while(lemmas_iter.hasNext()){
            //le lemme de la thematique
            Lemma_item lemma = (Lemma_item) lemmas_iter.next();
            //recuperer les lemmes du flux rss
            Iterator rss_lemmas_iter = article_lemmas.iterator();
            while(rss_lemmas_iter.hasNext()){
                Lemma_item rss_lemma = (Lemma_item) rss_lemmas_iter.next();
                if(rss_lemma.getLemmaName().equalsIgnoreCase(lemma.getLemmaName())){
                    result += (rss_lemma.getCountDesc())+(rss_lemma.getCountTitle());
//                            /(childsSize)
//                            )/niveau);
                }
            }
        }
        return result;
          
    }*/
    //fonction de fusion des enfants
    /*private Set<Lemma_item> childLemmas(Graph_item item){
        Set<Lemma_item> lemmas = new HashSet<Lemma_item>();
        //les lemmes du noeud
        //+tout les lemmes des enfants
        Set<Graph_item> childs = item.getChilds();
        Iterator c_iter = childs.iterator();
        while(c_iter.hasNext()){
            Graph_item child = (Graph_item) c_iter.next();
            lemmas.addAll(child.getLemmas());
        }
        return lemmas;
    }*/
    /*private void displayResults(HashMap results){
        Set resultSet = results.entrySet();
        Iterator iter = resultSet.iterator();
        double max = 0.0000;
        Object key = null;
        while(iter.hasNext()){
            Map.Entry entry = (Map.Entry)iter.next();
            double value = Double.parseDouble(entry.getValue().toString());
            if(value>max){
                max = value;
                key = entry.getKey();
            }
//            System.out.println("Catégorie: "+entry.getKey()+", score:"+value);
        }
        if(key != null){
        System.out.println(key.toString());
        }
        else{System.out.println("rien");}
    }*/
}
